package GraphicThreads;

import javafx.application.Platform;

import java.io.Serializable;

import UI.MyPane;
import Back.Node;
import Back.Tree;


public class CutThread<T extends Serializable & Comparable<T> > extends GraphicThread {
    T rem_value;

    /**
     * konstruktor
     * @param _pane smernik na pane na ktorom bude pracovat
     * @param val hodnota vrcholu ktory sa bude odrezavat
     */
    public CutThread(MyPane<T> _pane, String val ) {
        pane = _pane;
        tree = pane.getTree1();
        SLEEP_TIME = 1000;
        rem_value = (T) (val);
    }
    /**
     * zavola graficke odstranenie vrcholu
     */
    @Override
    public void run() {
        threadRemove(tree.getRoot(), new Node(rem_value, null) );

        Platform.runLater(() -> {
            pane.end();
        });

    }

}
